﻿using System;
using System.Reflection;
using System.ServiceProcess;
using System.Threading;
using VBECS.Services.Common.AppServices;
using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.Common.Log;

namespace VBECS.Service
{
    /// <summary>
    /// This is common service class that hosts IServer object
    /// </summary>
    public partial class Service1 : ServiceBase
    {
        readonly ILogger _logger = LogManager.Instance().LoggerLocator.GetLogger(MethodBase.GetCurrentMethod().DeclaringType);

        /// <summary>
        /// Instance constructor
        /// </summary>
        public Service1()
        {
            ServiceName = GlobalContext.Instance().ServiceProperties.Name;
        }

        #region Fields

        private IServer _serverProcess;

        #endregion

        #region Service Methods

        protected override void OnStart(string[] args)
        {
            if (_serverProcess != null)
            {
                _logger.Error(string.Format("{0}: Server is already started. Should never happen.", ServiceName));
                return;
            }
            
            _serverProcess = GlobalContext.Instance().Server;
            _serverProcess.FatalErrorOccured += ServerOnFatalErrorOccured;

            _logger.Debug(string.Format("{0}: Begin start server process", ServiceName));
            try
            {
                _serverProcess.Start();
            }
            catch (Exception ex)
            {
                _logger.Error("Server start has failed", ex);
                //do not start service is error occurred
                throw;
            }
            _logger.Debug(string.Format("{0}: Server process started successfully", ServiceName));
        }

        protected override void OnStop()
        {
            if (_serverProcess == null)
            {

                _logger.Error(string.Format("{0}: Server process is null. Should never happen.", ServiceName));
                return;
            }
            _logger.Debug(string.Format("{0}: Begin stop server process", ServiceName));
            _serverProcess.Stop();
            _serverProcess = null;
            _logger.Debug(string.Format("{0}: Server process stopped", ServiceName));
        }

        #endregion

        private void ServerOnFatalErrorOccured(object sender, ThreadExceptionEventArgs threadExceptionEventArgs)
        {
            _logger.Error("Server process has failed", threadExceptionEventArgs.Exception);
        }
    }
}
